class BreathFire extends ShockBeamFire; //LinkFire;
//I think instant fire handles its momentum a little differently, will need to look into this.

var float BeamRadius; //The radius of each breathfire beam (remember there are 9 beams)
var bool DisplayEdgeBeams;
var int FireAmount; //how many times to fire in a second.
var int ShotCount;

function DoFireEffect()
{
	//super.DoFireEffect();
	ShotCount = FireAmount;
	SetTimer((0.5/FireAmount), true);
}


function Timer(){
	if((FireAmount>0) && (ShotCount>0))
	{
		ShotCount--;
		super.DoFireEffect();
	}
	//else if(FireAmount>0)
	//	ShotCount=FireAmount; //Reset for the next shot.
}

//Fires 9 traces which trace out a cone-like shape.
function DoTrace(Vector Start, Rotator Dir) 
{ 
	local Rotator LeftShot;
	local Rotator RightShot;
	local Rotator UpShot;
	local Rotator DownShot;
	local Rotator UpLeftShot;
	local Rotator UpRightShot;
	local Rotator DownLeftShot;
	local Rotator DownRightShot;

//Messy code, but whatever

	RightShot = Dir;
	LeftShot = Dir;
	UpShot = Dir;
	DownShot = Dir;
	UpLeftShot = Dir;
	UpRightShot = Dir;
	DownLeftShot = Dir;
	DownRightShot = Dir;

	LeftShot.Yaw+=4096; //45 degrees
	RightShot.Yaw-=4096; // 45 degrees in the other direction
	UpShot.Pitch+=4096;
	DownShot.Pitch-=4096;
	
	//In between shots
	UpLeftShot.Yaw+=2048; //half of 45 degrees
	UpLeftShot.Pitch+=2048;
	
	UpRightShot.Yaw-=2048;
	UpRightShot.Pitch+=2048;
	
	DownLeftShot.Yaw+=2048;
	DownLeftShot.Pitch-=2048;
	
	DownRightShot.Yaw-=2048;
	DownRightShot.Pitch-=2048;


/*	super.DoTrace(Start, Dir);
	super.DoTrace(Start, LeftShot);
	super.DoTrace(Start, RightShot);
	super.DoTrace(Start, UpShot);
	super.DoTrace(Start, DownShot);
*/

	DoWideTrace(Start, Dir, false);
	DoWideTrace(Start, LeftShot, DisplayEdgeBeams);
	DoWideTrace(Start, RightShot, DisplayEdgeBeams);
	DoWideTrace(Start, UpShot, DisplayEdgeBeams);
	DoWideTrace(Start, DownShot, DisplayEdgeBeams);
	DoWideTrace(Start, UpLeftShot, false);
	DoWideTrace(Start, UpRightShot, false);
	DoWideTrace(Start, DownLeftShot, false);
	DoWideTrace(Start, DownRightShot, false);
}

//This is exactly the same as the instant fire's trace, except the extent parameter is bigger.
//So the beam width is about twice the weapon holder's collision radius. Also, doesn't display
//the beam and doesn't block projectiles.
function DoWideTrace(Vector Start, Rotator Dir, bool DisplayBeam)
{
    local Vector X, End, HitLocation, HitNormal, RefNormal;
    local Actor Other;
    local int Damage;
    local bool bDoReflect;
    local int ReflectNum;
    local Vector BeamExtent;
    local Vector actualMomentum;

	MaxRange();

   // Momentum = FMax(3*Momentum, (HoldTime/2)*Momentum); //changes the impact momentum to reflect the chargeup time.
    ReflectNum = 0;
    while (true)
    {
        bDoReflect = false;
        X = Vector(Dir);
        End = Start + TraceRange * X;
        
        BeamExtent = BeamRadius * vect(1,1,1);

        Other = Weapon.Trace(HitLocation, HitNormal, End, Start, true, BeamExtent);
        
        
        if ( Other != None && (Other != Instigator || ReflectNum > 0) )
        {
            if (bReflective && Other.IsA('xPawn') && xPawn(Other).CheckReflect(HitLocation, RefNormal, DamageMin*0.25))
            {
                bDoReflect = true;
                HitNormal = Vect(0,0,0);
            }
            else if ( !Other.bWorldGeometry && !Other.IsA('Projectile') )
            {
				Damage = DamageMin;
				if ( (DamageMin != DamageMax) && (FRand() > 0.5) )
					Damage += Rand(1 + DamageMax - DamageMin);
                Damage = Damage * DamageAtten;

				// Update hit effect except for pawns (blood) other than vehicles.
               	if ( Other.IsA('Vehicle') || (!Other.IsA('Pawn') && !Other.IsA('HitScanBlockingVolume')) )
					WeaponAttachment(Weapon.ThirdPersonActor).UpdateHit(Other, HitLocation, HitNormal);
		actualMomentum = Momentum*X;
		actualMomentum.Z = 0;
               	Other.TakeDamage(Damage, Instigator, HitLocation, actualMomentum, DamageType);
                HitNormal = Vect(0,0,0);
            }
            else if ( WeaponAttachment(Weapon.ThirdPersonActor) != None )
				WeaponAttachment(Weapon.ThirdPersonActor).UpdateHit(Other,HitLocation,HitNormal);
        }
        else
        {
            HitLocation = End;
            HitNormal = Vect(0,0,0);
			WeaponAttachment(Weapon.ThirdPersonActor).UpdateHit(Other,HitLocation,HitNormal);
        }

        if(DisplayBeam == true)
        	SpawnBeamEffect(Start, Dir, HitLocation, HitNormal, ReflectNum);

        if (bDoReflect && ++ReflectNum < 4)
        {
            //Log("reflecting off"@Other@Start@HitLocation);
            Start = HitLocation;
            Dir = Rotator(RefNormal); //Rotator( X - 2.0*RefNormal*(X dot RefNormal) );
        }
        else
        {
            break;
        }
    }
   // Momentum=default.Momentum;
}

defaultproperties
{    
     DisplayEdgeBeams = false
     BeamRadius = 70 //previously 70
     FireAmount = 20
     ShotCount=FireAmount
     //BeamEffectClass=none
     //DamageType=Class'XWeapons.DamTypeLinkShaft' //change later probably
    // Damage=0
     FireRate=2
    // MomentumTransfer=200000
     AmmoPerFire=0  // do not consume ammo
     DamageMin=0
     DamageMax=0
     TraceRange=500
     Momentum=200000
     bFireOnRelease = false
     bModeExclusive=false
}